/** @file   simon.cpp
 * @brief   Implementation of Simon - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#include "simon.h"
#include "gameanims.h"
#include "animplayer.h"
#include "settings.h"
#include "youkocontroller.h"
#include "soundsamples.h"
#include "AnimId.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================



///
/// Constructors, destructor and operators
/// ======================================
/** Constructor
 */
Simon::Simon() :
  NpcCharacter()
{
  int oid = ObjectID::TYPE_SIMON;
  this->setArmor( Settings::floatObjProp(oid, "armor:") );
  this->boundingSphere( Settings::floatObjProp(oid, "bsphere:") );
  m_movementVec.vy = - Settings::floatObjProp(oid, "walk_spd:");
  
  YoukoController* pC = new YoukoController( this );
  pC->youkoState( YoukoController::YOUKO_FIGHT );
  this->setController( pC );
  NpcCharacter::m_animationCombine = GameAnims::getAnimCombine( AnimId::KSimon );
  this->setAnimation( m_animationCombine->FindAnim(GameAnims::EIdle),
                      GameAnims::EIdle );
  
  
  
  // Setup the sounds
  m_soundIndices.at( GameObject::SND_ATTACK ) = SMP_WEAPON2;
  
  NpcCharacter::m_weapon = Weapon( Weapon::W_SHOTGUN );
}



/** Destructor
 */
Simon::~Simon()
{
}




///
/// Public methods
/// ==============

/** Updates this object.
 */
void Simon::update()
{
  if ( this->state() == GameObject::STATE_KILLED ) {
    return;
  }

  if ( this->state() == GameObject::STATE_DYING ) {
    if ( m_animation.paused() == true ) {
      this->state( GameObject::STATE_KILLED );
      this->changeAnimation( GameAnims::EKilled );
    }
    return;
  }

  YoukoController* pC = dynamic_cast<YoukoController*>( this->getController() );
  pC->update();
  this->changeAngle( pC->turn() );

  if ( pC->forward() == 0 ) {
    this->changeAnimation( GameAnims::EIdle );

  } else if ( pC->forward() == 1 ) {
    Vec2D mvec( m_movementVec );
    mvec.rotate( this->angle() );
    this->move( mvec );
    this->changeAnimation( GameAnims::EIdle );
  }
  
  if ( pC->shoot() != 0 ) {
    this->changeAnimation( GameAnims::EShoot );
    if ( this->reloading() == false ) {
      this->handleShooting();
    }
  }
}




///
/// Getter methods
/// ==============

/** Returns the type of this object
 */
ObjectID::Type Simon::objectType() const
{
  return ObjectID::TYPE_SIMON;
}



///
/// Private or Protected methods
/// ============================

} // end of namespace
